#Include <GuiMenu.au3>
#include <GuiListView.au3>
#include <GuiTab.au3>
#include <GuiTreeView.au3>
#include <GUIConstantsEx.au3>
#Include <GuiButton.au3>
#Include <GuiToolBar.au3>
#include <WindowsConstants.au3>


;$Titel_name_of_window_explorer = "Arbeitsplatz" ; german language operating system
$Titel_name_of_window_explorer = "My Computer" ; english language operating system

;$Name_of_menue_item_file_in_explorer_window = "&Datei" ; german language operating system
$Name_of_menue_item_file_in_explorer_window = "&File" ; english language operating system

;$Titel_name_of_window_folder_options = "Ordneroptionen" ; german language operating system
$Titel_name_of_window_folder_options = "Folder Options" ; english language operating system

;$Name_of_tab_View_in_folder_options = "Ansicht" ; german language operating system
$Name_of_tab_View_in_folder_options = "View" ; english language operating system

;$Name_of_item_Remember_each_folders_view_settings = "Ansichtoptionen fr jeden Ordner speichern"  ; german language operating system
$Name_of_item_Remember_each_folders_view_settings = "Remember each folder's view settings" ; english language operating system

; This value is used for the WinWait functions
$Global_wait_time = 4



; ########################
; # Start folder options #
; ########################
;run ("rundll32 shell32.dll, Options_RunDLL 0")
Run("explorer.exe /root, ,::{20D04FE0-3AEA-1069-A2D8-08002B30309D}")

;Run("explorer.exe")
WinWait ($Titel_name_of_window_explorer, "", $Global_wait_time )
If @error Then
    MsgBox(0, "Error", "Explorer Window did not appear")
	Exit
EndIf


;$handle_of_SysTabControl = ControlGetHandle($Titel_name_of_window_explorer, "", "[CLASS:ToolbarWindow32; INSTANCE:3]")
$handle_of_SysTabControl = _GUICtrlToolbar_FindToolbar($Titel_name_of_window_explorer, $Name_of_menue_item_file_in_explorer_window)
If @error Then
    MsgBox(0, "Error", "Could not find toolbar")
	Exit
EndIf

; Choose menu item Tools
_GUICtrlToolbar_ClickIndex($handle_of_SysTabControl, 4, "left", True)
;chose Options then
send("o")




; ########################################
; # Wait for folderoptions for X seconds #
; ########################################
WinWait ($Titel_name_of_window_folder_options, "", $Global_wait_time )

If @error Then
    MsgBox(0, "Error", "folder options did not appear within " & $Global_wait_time & " seconds")
	Exit
Else
	WinActivate($Titel_name_of_window_folder_options)
EndIf


; #######################################
; # Get handle of window folder options #
; #######################################
$handle_of_window_folder_options = WinGetHandle($Titel_name_of_window_folder_options)

If @error Then
    MsgBox(0, "Error", "Could not get handle of window " & $Titel_name_of_window_folder_options)
	Exit
Else
	MsgBox(0,"Handle", "Handle of window " & $Titel_name_of_window_folder_options & ": " & $handle_of_window_folder_options)
EndIf





; #################################
; # Get handle of SysTabControl32 #
; #################################
$handle_of_SysTabControl = ControlGetHandle($Titel_name_of_window_folder_options, "", "[CLASS:SysTabControl32; INSTANCE:1]")
If @error Then
	MsgBox(0, "Error", "Could not get handle of SysTabControl32")
	Exit
Else
	MsgBox(0,"Handle", "Handle of SysTabControl32: " & $handle_of_SysTabControl)
	$number_of_tabs = _GUICtrlTab_GetItemCount($handle_of_SysTabControl)
	MsgBox(0,"Tabs", "Number of tabs: " & $number_of_tabs)
EndIf



; ##############################
; # Check if tab "View" exists #
; ##############################

$Zero_based_index_of_tab_View = _GUICtrlTab_FindTab($handle_of_SysTabControl, $Name_of_tab_View_in_folder_options, True, 0)

If @error Then
	MsgBox(0, "Error", "Could not find tab " & $Name_of_tab_View_in_folder_options)
	Exit
Else
	MsgBox(0, "Index", "Zero based index of tab View: " & $Zero_based_index_of_tab_View)
EndIf



; #################################################
; # Click the tab "View" identified by it's index #
; #################################################

_GUICtrlTab_ClickTab($handle_of_SysTabControl, $Zero_based_index_of_tab_View, "left", True, 1)
If @error Then
	MsgBox(0, "Error", "Could not click the tab " & $Name_of_tab_View_in_folder_options)
	Exit
EndIf


; ###############################
; # Get Handle of SysTreeView32 #
; ###############################
$handle_of_treeview = ControlGetHandle($Titel_name_of_window_folder_options, "", "[CLASS:SysTreeView32; INSTANCE:1]")
If @error Then
	MsgBox(0, "Error", "Could not get handle of SysTreeView32")
	Exit
Else
	MsgBox(0,"Handle", "Handle of SysTreeView32: " & $handle_of_treeview)
EndIf


; #######################################################
; # Handle des ersten Items der SysTreeView32 ermitteln #
; #######################################################
$handle_of_first_item = _GUICtrlTreeView_GetFirstItem($handle_of_treeview)
If @error Then
	MsgBox(4096, "Error", "Konnte Handle des ersten Items der SysTreeView32 nicht ermitteln")
Else
	MsgBox(4096,"Handle", "Handle des ersten Items der SysTreeView32: " & $handle_of_first_item)
	MsgBox(4096,"Handle", "Text des ersten Items der SysTreeView32: " & _GUICtrlTreeView_GetText($handle_of_treeview, $handle_of_first_item))
EndIf

	
; #########################################################
; # Handle des nchsten Items der SysTreeView32 ermitteln #
; #########################################################
$handle_of_next_item = _GUICtrlTreeView_GetNext($handle_of_treeview, $handle_of_first_item)
If @error Then
	MsgBox(4096, "Error", "Konnte Handle des nchsten Items der SysTreeView32 nicht ermitteln")
Else
	MsgBox(4096,"Handle", "Handle des nchsten Items: " & $handle_of_next_item)
	MsgBox(4096,"Handle", "Text des nchsten Items: " & _GUICtrlTreeView_GetText($handle_of_treeview, $handle_of_next_item))
EndIf


$first_item = _GUICtrlTreeView_GetFirstItem($handle_of_treeview)

$text = _GUICtrlTreeView_GetText($handle_of_treeview, $first_item)
$file = FileOpen("c:\test.txt", 1)
FileWriteLine ( $file, $text )

$next_item = _GUICtrlTreeView_GetNext($handle_of_treeview, $first_item)
$text = _GUICtrlTreeView_GetText($handle_of_treeview, $next_item)
FileWriteLine ( $file, $text )

FileClose($file)



; ############################################################
; # Get handle of item "Remember each folder's view settings #
; ############################################################
$handle_of_item_Remember_each_folders_view_settings = _GUICtrlTreeView_FindItem($handle_of_treeview, $Name_of_item_Remember_each_folders_view_settings)
If $handle_of_item_Remember_each_folders_view_settings = 0 Then
	MsgBox(0, "Error", "Could not find item """ & $Name_of_item_Remember_each_folders_view_settings & """")
	Exit
Else
	MsgBox(0,"Handle", "Handle of tem """ & $Name_of_item_Remember_each_folders_view_settings & """: " & $handle_of_item_Remember_each_folders_view_settings)
	MsgBox(0,"Text", "Text of item """ & $Name_of_item_Remember_each_folders_view_settings & """: " & _GUICtrlTreeView_GetText($handle_of_treeview, $handle_of_item_Remember_each_folders_view_settings))
EndIf
	
	
; #######################################
; # Test if checkbox of item is checked #
; #######################################
MsgBox(0,"Test checkbox of item", "Item """ & $Name_of_item_Remember_each_folders_view_settings & """ ? " & _GUICtrlTreeView_GetChecked($handle_of_treeview, $handle_of_item_Remember_each_folders_view_settings))


; #################################
; # Get Handle of Button "Cancel" #
; #################################
$Handle_of_Button_Cancel = ControlGetHandle ($Titel_name_of_window_folder_options, "", "[CLASS:Button; INSTANCE:6]")

If @error Then
	MsgBox(0, "Error", "Could not get handle of Button ""Cancel""")
	Exit
Else
	MsgBox(0,"Handle", "Handle of Button ""Cancel"": " & $Handle_of_Button_Cancel)
EndIf

; #########################
; # Click "Cancel" Button #
; #########################

_GUICtrlButton_Click($Handle_of_Button_Cancel)